function Enforce-Intranet {
	# Path for the Edge policies in the registry
	$edgePolicyPath = "HKLM:\SOFTWARE\Policies\Microsoft\Edge"

	# Create the Edge policy registry path if it doesn't exist
	if (-not (Test-Path -Path $edgePolicyPath)) {
	    New-Item -Path $edgePolicyPath -Force | Out-Null
	}

	# Set the policy to open a list of URLs on startup
	Set-ItemProperty -Path $edgePolicyPath -Name "RestoreOnStartup" -Value 4

	# Set the list of URLs to open
	$urlListPath = Join-Path -Path $edgePolicyPath -ChildPath "RestoreOnStartupURLs"
	if (-not (Test-Path -Path $urlListPath)) {
	    New-Item -Path $urlListPath -Force | Out-Null
	}

	Set-ItemProperty -Path $urlListPath -Name "1" -Value "https://fictor.sharepoint.com"

	Write-Host "Policy applied. Microsoft Edge will open https://fictor.sharepoint.com on startup."
}

Enforce-Intranet